<?php

if( ! defined( 'ABSPATH' ) || ! current_user_can( 'subscriber' ) ){
    return;
}

$key = \Malicr\User_Link::get_the_user_key();
?>
<div class="wrap">
    <h1><?php _e( 'Settings | Magic Link Creator', 'malicr' ); ?></h1>
    <form action="#" class="malicr-form-user-key" method="post">
        <input type="text" required name="key" class="regular-text" value="<?php echo esc_attr( $key ); ?>" placeholder="<?php esc_attr_e( 'Master key', 'malicr' ); ?>" />
        <button type="submit" class="button-primary"><?php esc_html_e( 'Set Master Key', 'malicr' ); ?></button>
        <p class="malicr-magic-url-text"><?php
            printf( __( 'Your Magic URL: %s', 'malicr' ), 
                '<span class="malicr-magic-url-link">'
                    . ( $key 
                        ? 
                            sprintf( '<a class="malicr-magic-url" href="%s">%s</a>',
                                esc_attr( add_query_arg( 'x', $key, home_url() ) ),
                                esc_html( add_query_arg( 'x', $key, home_url() ) ) )
                        :   __( 'N/A', 'malicr' ) ) 
                . '</span>' ); ?></p>
    </form>
    <div class="malicr-table-shortcodes">
        <form action="#" method="post" class="malicr-form-user-shortcodes">
            <?php 
                submit_button( __( 'Save Changes', 'malicr' ) );
                $table = new \Malicr\WP_List_Table_User_Shortcodes();
                $table->prepare_items(); 
                $table->views();
                $table->display();
                submit_button( __( 'Save Changes', 'malicr' ), 'primary', '', '', [
                    'id' => 'malicr-save-changes-2'
                ] );
            ?>
        </form>
    </div>
</div>