<?php

if( ! defined( 'ABSPATH' ) || ! current_user_can( 'administrator' ) ){
    return;
}

$view = trim( filter_input( INPUT_GET, 'type' ) );
$view = ( '' !== $view ) ? $view : 'link';

?>
<div class="wrap">
    <h1><?php _e( 'Settings | Magic Link Creator', 'malicr' ); ?></h1>
    <form action="#" class="malicr-form-add-shortcode" method="post">
        <input type="text" required name="shortcode" placeholder="<?php esc_attr_e( 'Shortcode', 'malicr' ); ?>" />
        <?php if( 'link' === $view ): ?>
            <input type="text" required name="value" class="regular-text" placeholder="<?php esc_attr_e( 'Link', 'malicr' ); ?>" />
        <?php endif; 
        if( 'text' === $view ): 
            wp_editor( '', 'value', [
                'media_buttons' => false,
                'textarea_name' => 'value',
                'textarea_rows' => 8,
                'teeny' => true,
                'quicktags' => true,
                'tinymce' => false
            ] );
        endif;
        if( 'image' === $view ): ?>
            <div class="malicr-add-image">
                <input type="hidden" name="value" class="malicr-add-image-val" />
                <div class="malicr-add-image-upload">
                    <button type="button" class="malicr-add-image-button button-secondary"><?php _e( 'Select Image', 'malicr' ); ?></button>
                </div>
            </div>
        <?php endif; ?>
        <input type="hidden" name="type" value="<?php echo esc_attr( $view ); ?>" />
        <button type="submit" class="button-primary"><?php esc_html_e( 'Add Shortcode', 'malicr' ); ?></button>
    </form>
    <div class="malicr-table-shortcodes">
        <?php 
            $table = new \Malicr\WP_List_Table_Shortcode();
            $table->prepare_items(); 
            $table->views();
            $table->display();
        ?>
    </div>
</div>