<?php

namespace Malicr;

if( ! defined( 'ABSPATH' ) ) {
    return;
}

class WP_List_Table_User_Shortcodes extends \Malicr\WP_List_Table{
    protected $malicr_view = 'link';
    
    public function __construct( $args = array() ) {
        $view = trim( filter_input( INPUT_GET, 'type' ) );
        $this->malicr_view = ( '' !== $view ) ? $view : 'link';
        $labels = [
            'link' => __( 'Link', 'malicr' ),
            'text' => __( 'Paragraph', 'malicr' ),
            'image' => __( 'Image', 'malicr' )
        ];
        $this->_column_headers = [
            [
                'name' => __( 'Name', 'malicr' ),
                'value' => $labels[ $this->malicr_view ],
            ], [], []
        ];
        parent::__construct( $args );
    }
    
    public function prepare_items() {
        $page = (int) filter_input( INPUT_GET, 'paged' );
        $per_page = 30;
        $shortcodes = Shortcode::get_shortcodes( $page, $per_page, $this->malicr_view );
        $items = [];
        $current_user_id = get_current_user_id();
        foreach( $shortcodes as $shortcode ) {
            $user_link = User_Link::get_by_shortcode_id( $shortcode->id, $current_user_id );
            $item = [
                'id' => ( false !== $user_link ) ? $user_link->id : 0,
                'shortcode' => $shortcode,
                'value' => ( false !== $user_link ) ? $user_link->value : ''
            ];
            $items[] = $item;
        }
        
        $this->items = $items;
        $total = Shortcode::get_total_count();
        $this->_pagination_args = array(
            'total_items' => $total,
            'total_pages' => ceil( $total / $per_page ),
            'per_page'    => $per_page
        );
    }
    
    public function get_columns() {
        return $this->_column_headers[0];
    }
    
    protected function get_views() {
        $types = [
            'link' => __( 'Links', 'malicr' ),
            'text' => __( 'Paragraphs', 'malicr' ),
            'image' => __( 'Images', 'malicr' )
        ];
        $views = [];
        
        foreach( $types as $type => $label ) {
            $views[ $type ] = sprintf( '<a href="%s"%s>%s</a>', 
            add_query_arg( 'type', $type ),
            ( $this->malicr_view === $type ? ' class="current"' : '' ), 
            $label );
        };
        
        return $views;
    }
    
# COLUMNS
    
    public function column_name( $item ) {
        echo esc_html( $item['shortcode']->name );
    }
    public function column_value( $item ) {
        $name = $item['id'] ? "update[{$item['id']}]" : "add[{$item['shortcode']->id}]";
        if( 'link' === $item['shortcode']->type ) {
            printf( '<input type="text" placeholder="%s" value="%s" name="%s" class="regular-text" />',
                esc_attr__( 'Link', 'malicr' ), esc_attr( $item['value'] ), $name );
        }
        if( 'text' === $this->malicr_view ) {
            wp_editor( $item['value'], 'value-' . $item['shortcode']->id, [
                'media_buttons' => false,
                'textarea_name' => $name,
                'textarea_rows' => 8,
                'teeny' => true,
                'quicktags' => true,
                'tinymce' => false
            ] );
        }
        if( 'image' === $this->malicr_view ):
            $has_value = ! empty( $item['value'] );
            if( $has_value ) {
                $thumbnail_url = Manager::get_image_url( $item['value'], 'thumbnail' );
                $full_url = Manager::get_image_url( $item['value'], 'full' );
            }
            ?>
            <div class="malicr-add-image">
                <input type="hidden" name="<?php echo $name; ?>" class="malicr-add-image-val" value="<?php echo esc_attr( $item['value'] ); ?>" />
                <?php if( $has_value ): ?>
                    <a href="<?php echo esc_attr( $full_url ); ?>" target="_blank" class="malicr-add-image-upload" style="background-image: url(<?php echo esc_attr( $thumbnail_url ); ?>)">
                <?php else: ?>
                    <div class="malicr-add-image-upload">
                <?php endif; ?>
                        <button type="button" class="malicr-add-image-button button-secondary"><?php _e( 'Select Image', 'malicr' ); ?></button>
                <?php printf( '</%s>', ( $has_value ? 'a' : 'div' ) ); ?>
            </div>
        <?php endif;
    }
}