<?php

namespace Malicr;

if( ! defined( 'ABSPATH' ) ) {
    return;
}

class WP_List_Table_Shortcode extends \Malicr\WP_List_Table{
    protected $malicr_view = 'link';
    public function __construct( $args = array() ) {
        $view = trim( filter_input( INPUT_GET, 'type' ) );
        $this->malicr_view = ( '' !== $view ) ? $view : 'link';
        $labels = [
            'link' => __( 'Link', 'malicr' ),
            'text' => __( 'Paragraph', 'malicr' ),
            'image' => __( 'Image', 'malicr' )
        ];
        $this->_column_headers = [
            [
                'name' => __( 'Name', 'malicr' ),
                'value' => $labels[ $this->malicr_view ],
                'shortcode' => __( 'Shortcode', 'malicr' ),
                'update' => __( 'Update', 'malicr' ),
                'delete' => __( 'Delete', 'malicr' )
            ], [], []
        ];
        parent::__construct( $args );
    }
    
    protected function get_views() {
        $types = [
            'link' => __( 'Links', 'malicr' ),
            'text' => __( 'Paragraphs', 'malicr' ),
            'image' => __( 'Images', 'malicr' )
        ];
        $views = [];
        
        foreach( $types as $type => $label ) {
            $views[ $type ] = sprintf( '<a href="%s"%s>%s</a>', 
            add_query_arg( 'type', $type ),
            ( $this->malicr_view === $type ? ' class="current"' : '' ), 
            $label );
        };
        
        return $views;
    }
    
    public function prepare_items() {
        $page = (int) filter_input( INPUT_GET, 'paged' );
        $per_page = 30;
        $this->items = Shortcode::get_shortcodes( $page, $per_page, $this->malicr_view );
        $total = Shortcode::get_total_count();
        $this->_pagination_args = array(
            'total_items' => $total,
            'total_pages' => ceil( $total / $per_page ),
            'per_page'    => $per_page
        );
    }
    
    public function get_columns() {
        return $this->_column_headers[0];
    }
    
# COLUMNS
    
    public function column_name( $shortcode ) {
        printf( '<input type="text" placeholder="%s" value="%s" name="name" />',
                esc_attr__( 'Shortcode name', 'malicr' ), esc_attr( $shortcode->name ) );
    }
    public function column_value( $shortcode ) {
        if( 'link' === $this->malicr_view ) {
            printf( '<input type="text" placeholder="%s" value="%s" name="value" class="regular-text" />',
                esc_attr__( 'Link', 'malicr' ), esc_attr( $shortcode->value ) );
        }
        if( 'text' === $this->malicr_view ) {
            printf( '<p class="malicr-text-preview">%s</p>', $shortcode->get_text_preview() );
            echo '<div class="malicr-editor">';
            wp_editor( $shortcode->value, 'value-' . $shortcode->id, [
                'media_buttons' => false,
                'textarea_name' => 'value',
                'textarea_rows' => 8,
                'teeny' => true,
                'quicktags' => true,
                'tinymce' => false
            ] );
            echo '</div>';
        }
        if( 'image' === $this->malicr_view ):
            $thumbnail_url = Manager::get_image_url( $shortcode->value, 'thumbnail' );
            $full_url = Manager::get_image_url( $shortcode->value, 'full' ); ?>
            <div class="malicr-add-image">
                <input type="hidden" name="value" class="malicr-add-image-val" value="<?php echo esc_attr( $shortcode->value ); ?>" />
                <a href="<?php echo esc_attr( $full_url ); ?>" target="_blank" class="malicr-add-image-upload" style="background-image: url(<?php echo esc_attr( $thumbnail_url ); ?>)">
                    <button type="button" class="malicr-add-image-button button-secondary"><?php _e( 'Select Image', 'malicr' ); ?></button>
                </a>
            </div>
        <?php endif;
    }
    public function column_shortcode( $shortcode ) {
        printf( '<code class="malicr-text-copy">%s</code>',
            sprintf( '[magiclink name=%s /]', esc_attr( $shortcode->name ) ) );
    }
    
    public function column_update( $shortcode ) {
        if( 'text' === $this->malicr_view ) {
            printf( '<button type="button" class="malicr-button-edit-shortcode button-secondary"'
                . ' data-malicr-shortcode-id="%d">%s</button>',
                $shortcode->id, esc_html__( 'Edit', 'malicr' ) );
        }
        printf( '<button type="button" class="malicr-button-update-shortcode button-primary"'
                . ' data-malicr-shortcode-id="%d">%s</button>',
                $shortcode->id, esc_html__( 'Update', 'malicr' ) );
    }
    
    public function column_delete( $shortcode ) {
        printf( '<button type="button" class="malicr-button-delete-shortcode button-secondary"'
                . ' data-malicr-shortcode-id="%d">%s</button>',
                $shortcode->id, esc_html__( 'Delete', 'malicr' ) );
    }
}