<?php

namespace Malicr;

if( ! defined( 'ABSPATH' ) ){
    return;
}

class User_Link{
    const table_name = 'user_links';

    public $id = 0;
    public $shortcode_id = 0;
    public $value = '';
    public $user_id = 0;
    
    public function __construct( $id = 0 ) {
        if( $id ) {
            $data = self::get_data_by_id( $id );
            if( $data ) {
                $this->set_data( $data );
            }
        }
    }
    
    
    public static function delete_all_by_shortcode_id( $shortcode_id ) {
        global $wpdb;
        
        $deleted = $wpdb->delete( self::get_table_name(), [
            'shortcode_id' => $shortcode_id
        ], ['%d'] );
        
        return (boolean) $deleted;
    }
    
    public function get_data_by_id( $id ) {
        global $wpdb;
        
        $table_name = self::get_table_name();
        
        $row = $wpdb->get_row( $wpdb->prepare( 
                "SELECT * FROM `$table_name` WHERE `id`=%d", $id ), ARRAY_A );
        
        if( empty( $row ) ) {
            return false;
        }
        
        return $row;
    }
    
    public function exists() {
        return ( $this->id > 0 );
    }
    
    public function set_data( $data ) {
        $this->id = (int) $data['id'];
        $this->user_id = (int) $data['user_id'];
        $this->shortcode_id = (int) $data['shortcode_id'];
        $this->value = trim( $data['link'] );
    }
    
    public function update_link( $value ) {
        global $wpdb;
        $table_name = self::get_table_name();
        
        $updated = $wpdb->update( $table_name, [
            'link' => $value
        ], [
            'id' => $this->id
        ], ['%s'], ['%d'] );
        
        return ( false !== $updated );
    }
    
    public static function insert_new( $data ) {
        global $wpdb;
        
        $inserted = $wpdb->insert( self::get_table_name(), [
            'user_id' => (int) $data['user_id'],
            'shortcode_id' => (int) $data['shortcode_id'],
            'link' => $data['value']
        ], ['%d', '%d', '%s'] );
        
        return (boolean) $inserted;
    }
    
    public static function get_by_shortcode_id( $shortcode_id, $user_id ) {
        global $wpdb;
        
        $table_name = self::get_table_name();
        
        $row = $wpdb->get_row( $wpdb->prepare(
                "SELECT * FROM `$table_name` WHERE `user_id`=%d AND `shortcode_id`=%d",
                $user_id, $shortcode_id ), ARRAY_A );
        
        if( empty( $row ) ) {
            return false;
        }
        
        $user_link = new User_Link();
        $user_link->set_data( $row );
        
        return $user_link;
    }
    
    public static function get_table_name() {
        $table_name = Manager::get_table_name( self::table_name );
        
        return $table_name;
    }
    
    public static function setup_db() {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();
        $table_name = Manager::get_table_name( self::table_name );

        $sql = "CREATE TABLE `$table_name` (
            `id` bigint(20) NOT NULL AUTO_INCREMENT,
            `user_id` bigint(20) NOT NULL,
            `shortcode_id` bigint(20) NOT NULL,
            `link` text NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
    
    public static function get_user_id_by_key( $key ) {
        $users = get_users( [
            'meta_key' => 'malicr_key',
            'meta_value' => $key
        ] );
        
        if( empty( $users ) ) {
            return false;
        }
        
        return $users[0]->ID;
    }
    
    public static function set_key_for_user( $user_id, $key ) {
        $updated = update_user_meta( $user_id, 'malicr_key', $key );
        
        return (boolean) $updated;
    }
    
    public static function get_the_user_key() {
        return self::get_user_key( get_current_user_id() );
    }
    
    public static function get_user_key( $user_id ) {
        $key = trim( get_user_meta( $user_id, 'malicr_key', true ) );
        
        return $key;
    }
}