<?php

namespace Malicr;

if( ! defined( 'ABSPATH' ) ){
    return;
}

class Shortcode{
    const table_name = 'shortcodes';

    public $id = 0;
    public $name = '';
    public $value = '';
    public $type = '';

    public function __construct( $id = 0 ) {
        if( $id ) {
            $data = self::get_shortcode_data_by_id( $id );
            if( $data ) {
                $this->set_data( $data );
            }
        }
    }
    
    public function exists() {
        return ( $this->id > 0 );
    }
    
    public function update( $name, $value ) {
        global $wpdb;
        $table_name = self::get_table_name();
        
        $updated = $wpdb->update( $table_name, [
            'name' => $name,
            'link' => $value
        ], [
            'id' => $this->id
        ], ['%s', '%s'], ['%d'] );
        
        return ( false !== $updated );
    }
    
    public function delete_by_id( $id ) {
        global $wpdb;
        
        $deleted = $wpdb->delete( self::get_table_name(), [
            'id' => $id
        ], ['%d'] );
        
        return (boolean) $deleted;
    }
    
    public function set_data( $data ) {
        $this->id = (int) $data['id'];
        $this->name = trim( $data['name'] );
        $this->value = trim( $data['link'] );
        $this->type = $data['type'];
        if( empty( $data['type'] ) ) {
            $this->type = 'link';
        }
    }
    
    public static function setup_db() {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();
        $table_name = self::get_table_name();

        $sql = "CREATE TABLE `$table_name` (
            `id` bigint(20) NOT NULL AUTO_INCREMENT,
            `name` text NOT NULL,
            `link` text NOT NULL,
            `type` varchar(5) DEFAULT 'link' NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
    
    public static function get_table_name() {
        $table_name = Manager::get_table_name( self::table_name );
        
        return $table_name;
    }
    
    public static function get_shortcode_by_name( $name ) {
        global $wpdb;
        
        $table_name = self::get_table_name();
        
        $row = $wpdb->get_row( $wpdb->prepare( 
                "SELECT * FROM `$table_name` WHERE `name`=%s", $name ), ARRAY_A );

        if( empty( $row ) ) {
            return false;
        }
        
        $shortcode = new Shortcode();
        $shortcode->set_data( $row );
        
        return $shortcode;
    }
    
    public static function get_shortcode_data_by_id( $id ) {
        global $wpdb;
        
        $table_name = self::get_table_name();
        
        $row = $wpdb->get_row( $wpdb->prepare( 
                "SELECT * FROM `$table_name` WHERE `id`=%d", $id ), ARRAY_A );
        
        if( empty( $row ) ) {
            return false;
        }
        
        return $row;
    }
    
    public static function insert_new( $data ) {
        global $wpdb;
        
        $inserted = $wpdb->insert( self::get_table_name(), [
            'name' => $data['name'],
            'link' => $data['value'],
            'type' => $data['type']
        ], ['%s', '%s', '%s'] );

        return (boolean) $inserted;
    }
    
    public static function get_shortcodes( $page, $per_page, $type = false ) {
        $page = max( 1, (int) $page );
        
        global $wpdb;
        $table_name = self::get_table_name();
        
        $where = '';
        if( false !== $type && in_array( $type, ['link', 'text', 'image'] ) ) {
            $where = ' WHERE `type`="' . $type . '"';
        }
        
        $results = $wpdb->get_results( $wpdb->prepare( 
                "SELECT * FROM `$table_name`$where ORDER BY `id` DESC LIMIT %d OFFSET %d", 
                $per_page, ( $page - 1 ) * $per_page ), ARRAY_A );
        
        $shortcodes = [];
        if( ! empty( $results ) ) {
            foreach( $results as $result ) {
                $shortcode = new Shortcode();
                $shortcode->set_data( $result );
                $shortcodes[] = $shortcode;
            }
        }
        
        return $shortcodes;
    }
    
    public static function get_total_count() {
        global $wpdb;
        $table_name = self::get_table_name();
        
        $count = $wpdb->get_var( "SELECT COUNT(*) FROM `$table_name`" );
        
        return (int) $count;
    }
    
    public function get_text_preview() {
        return wp_trim_words( strip_tags( $this->value ), 12 );
    }
}