jQuery( document ).ready( function() {
    
    // --- Settings -- //
    ( function( $ ) {
        'use strict';
        
        var $table = $( '.malicr-table-shortcodes' );
        if( $table.length < 1 ) {
            return;
        }
        
        
        function update_table(){
            $table.addClass( 'malicr-loading' );
            var $container = $( '<div />' );
            $container.load( window.location.href + ' .malicr-table-shortcodes', function() {
                $table.replaceWith( $container.find( '.malicr-table-shortcodes' ) );
                $table = $( '.malicr-table-shortcodes' );
                if( $table.find( '.malicr-editor' ).length > 0 ) {
                    $table.find( 'tbody tr' ).each( function() {
                        var $row = $( this );
                        var shortcode_id = $row.find( '.malicr-button-update-shortcode' )
                                .data( 'malicrShortcodeId' );
                        quicktags( {
                            id : 'value-' + shortcode_id
                        } );
                    } );
                }
            } );
        }
        
        // admin settings
        $( 'body' )
            .on( 'submit', '.malicr-form-add-shortcode', function() {
                var $form = $( this ),
                    data = $form.serialize();
                    
                $form.addClass( 'malicr-loading' );
                var $table = $( '.malicr-table-shortcodes' );
                $table.addClass( 'malicr-loading' );

                $.post( ajaxurl, {
                    action: 'malicr_add_shortcode',
                    data: data
                }, function( response ) {
                    if( 'error' === response.type ) {
                        alert( response.message );
                        $table.removeClass( 'malicr-loading' );
                    }
                    else{
                        $form.trigger( 'reset' );
                        update_table();
                    }
                    
                    $form.removeClass( 'malicr-loading' );
                    
                }, 'json' );

                return false;
            } )
            .on( 'submit', '.malicr-form-user-shortcodes', function() {
                var $form = $( this ),
                    data = $form.serialize();
                    
                $form.addClass( 'malicr-loading' );

                $.post( ajaxurl, {
                    action: 'malicr_update_user_links',
                    data: data
                }, function( response ) {
                    if( 'error' === response.type ) {
                        alert( response.message );
                    }
                    
                    $form.removeClass( 'malicr-loading' );
                    
                }, 'json' );   
                
                return false;
            } )
            .on( 'click', '.malicr-text-copy', function() {
                var el = this;
                window.getSelection().selectAllChildren( el );
            } )
            .on( 'click', '.malicr-button-update-shortcode', function() {
                var $button = $( this ),
                    $row = $button.closest( 'tr' );
                    
                $row.removeClass( 'malicr-mode-editing' ).find( 'td' ).addClass( 'malicr-loading' );
                $.post( ajaxurl, {
                    action: 'malicr_update_shortcode',
                    id: $button.data( 'malicrShortcodeId' ),
                    name: $row.find( '[name="name"]' ).val(),
                    value: $row.find( '[name="value"]' ).val()
                }, function( response ) {
                    if( 'error' === response.type ) {
                        alert( response.message );
                    }
                    else{
                        update_table();
                    }
                    $row.find( 'td' ).removeClass( 'malicr-loading' );
                }, 'json' );
            } )
            .on( 'click', '.malicr-button-delete-shortcode', function() {
                var $button = $( this ),
                    $row = $button.closest( 'tr' );
                    
                $row.find( 'td' ).addClass( 'malicr-loading' );
                $.post( ajaxurl, {
                    action: 'malicr_delete_shortcode',
                    id: $button.data( 'malicrShortcodeId' )
                }, function( response ) {
                    if( 'error' === response.type ) {
                        alert( response.message );
                        $row.find( 'td' ).removeClass( 'malicr-loading' );
                    }
                    else{
                        update_table();
                    }
                }, 'json' );
            } )
            .on( 'click', '.malicr-button-edit-shortcode', function() {
                $( this ).closest( 'tr' ).addClass( 'malicr-mode-editing' );
            } )
            .on( 'click', '.malicr-add-image-button', function( e ) {
                e.preventDefault();
                e.stopPropagation();
                var $button = $( this ),
                uploader = wp.media({
                    title: 'Custom image',
                    library : {
                        type : 'image'
                    },
                    button: {
                        text: 'Select image'
                    },
                    multiple: false
                } )
                .on( 'select', function() {
                    var attachment = uploader.state().get( 'selection' ).first().toJSON();
                    $button.closest( '.malicr-add-image' ).find( '.malicr-add-image-val' )
                        .val( attachment.id );
                    $button.parent().css( 'background-image', 'url(' + attachment.url + ')' );
                } )
                .open(); 
            } );
            
        // user settings
        $( 'body' )
            .on( 'submit', '.malicr-form-user-key', function() {
                var $form = $( this ),
                    key = $form.find( '[name="key"]' ).val();
                    
                $form.addClass( 'malicr-loading' );
                    
                $.post( ajaxurl, {
                    action: 'malicr_set_user_key',
                    key: key
                }, function( response ) {
                    if( 'error' === response.type ) {
                        alert( response.message );
                    }
                    else{
                        var $link = $( '<a />', {
                            href: response.data['url']
                        } );
                        $link.text( response.data['url'] );
                        $( '.malicr-magic-url-link' ).empty().append( $link );
                    }
                    $form.removeClass( 'malicr-loading' );
                }, 'json' );
                
                return false;
            } );
    } ( jQuery ) );
    
} );