<?php

/*
Plugin Name: Dynamic Keyword Pages
Description: Add keywords into a page and have it dynamically displayed in the content from a URL variable. 
Version: 1.0.0
Author: 1099 Systems
Author URI: https://1099systems.com
License: GPLv2 or later
Text Domain: bkw
*/

global $bkw_var;
$bkw_var = '';

function bkw_set_the_var( $var ) {
    global $bkw_var;
    $bkw_var = $var;
}

function bkw_get_the_var(){
    global $bkw_var;
    return $bkw_var;
}

add_action( 'add_meta_boxes', 'bkw_hook_add_meta_boxes' );
function bkw_hook_add_meta_boxes(){
    add_meta_box( 'bkw', __( 'Builder Keyword', 'bkw' ), 'bkw_metabox', null, 'side' );
}

function bkw_metabox( $post ){
    $checked = checked( (boolean) get_post_meta( $post->ID, 'bkw_enabled', true ), true, false );
    $label = __( 'Dynamic Keyword Page Activated', 'bkw' );
    echo "<label><input type='checkbox' name='bkw_enabled' $checked value='1' />$label</label>";
}

add_action( 'save_post', 'bkw_hook_save_post' );
function bkw_hook_save_post( $post_id ){
    $enabled = (boolean) filter_input( INPUT_POST, 'bkw_enabled' );
    update_post_meta( $post_id, 'bkw_enabled', (int) $enabled );
}

add_action( 'wp', 'bkw_hook_wp' );
function bkw_hook_wp(){
    if( ! is_singular() ) {
        return;
    }
    $enabled = (boolean) get_post_meta( get_the_ID(), 'bkw_enabled', true );
    if( ! $enabled ) {
        return;
    }
    
    $var = trim( filter_input( INPUT_GET, 'bk' ) );
    $var = trim( str_replace( '_', ' ', $var ) );
    if( '' === $var ) {
        return;
    }
    
    bkw_set_the_var( $var );
    add_filter( 'document_title_parts', 'bkw_hook_document_title_parts', 5 );
    add_shortcode( 'builder-keyword', 'bkw_shortcode_builder_keyword' );
}

function bkw_hook_document_title_parts( $parts ){
    $var = esc_html( bkw_get_the_var() );
    $parts['title'] .= " $var";
    
    return $parts;
}

function bkw_shortcode_builder_keyword(){
    return esc_html( bkw_get_the_var() );;
}